const express = require("express");
const SiteRouter = express.Router();
const multer = require("multer");
const { siteController } = require("../controllers");
const handleToken = require("../models/handleToken/handlerToken");

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, "images/site/"); // Destination folder for storing images
  },
  filename: function (req, file, cb) {
    cb(null, file.originalname); // Keep original filename
  },
});
const upload = multer({ storage: storage });

// ......................

SiteRouter.post(
  "/add",
  handleToken,
  upload.fields([
    { name: "site_map", maxCount: 1 },
    { name: "site_brochure", maxCount: 1 },
  ]),
  siteController.addSite
);
SiteRouter.get("/",handleToken, siteController.getSite);
SiteRouter.get("/:id", handleToken, siteController.getSiteById);
SiteRouter.get("/delete/:id", handleToken, siteController.deleteSite);
SiteRouter.get("/status/:id", handleToken, siteController.activateSite);
SiteRouter.post("/addMorePlot/:id", handleToken, siteController.addMorePlot);

SiteRouter.put(
  "/:id",
  handleToken,
  upload.fields([
    { name: "site_map", maxCount: 1 },
    { name: "site_brochure", maxCount: 1 },
  ]),
  siteController.updateSite
);

module.exports = SiteRouter;
