const express = require("express");
const PlotRouter = express.Router();
const multer = require("multer");
const { plotController } = require("../controllers");
const handleToken = require("../models/handleToken/handlerToken");

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, "images/plot/"); // Destination folder for storing images
  },
  filename: function (req, file, cb) {
    cb(null, file.originalname); // Keep original filename
  },
});
const upload = multer({ storage: storage });

// ......................

PlotRouter.post("/add", handleToken, plotController.addPlot);
PlotRouter.get("/", plotController.getPlot);
PlotRouter.get("/:id", handleToken, plotController.getPlotById);
PlotRouter.get("/delete/:id", handleToken, plotController.deletePlot);
PlotRouter.get("/status/:id", handleToken, plotController.activatePlot);
PlotRouter.put("/:id", handleToken, plotController.updatePlot);

module.exports = PlotRouter;
