const { boolean } = require("joi");
const sequelize = require("./config");

const Site = sequelize.define("sites", {
  site_name: {
    type: String,
    required: true,
  },
  mauja: {
    type: String,
    required: true,
  },
  patwali_halka: {
    type: String,
    required: true,
  },
  khasara: {
    type: String,
    required: true,
  },
  rera: {
    type: String,
    required: false,
  },
  site_map: {
    type: String,
    required: true,
  },
  site_brochure: {
    type: String,
    required: false,
  },
  address: {
    type: String,
    required: true,
  },
  pincode: {
    type: Number,
    required: true,
  },
  total_plot: {
    type: Number,
    required: true,
  },
  residential: {
    type: Number,
    required: true,
  },
  commercial: {
    type: Number,
    required: true,
  },
  is_active: {
    type: boolean,
    required: true,
    default: true,
  },
  is_delete: {
    type: boolean,
    required: true,
    default: false,
  },
});

module.exports = Site;
